//
//  ContentView.swift
//  SwiftPagingTest
//
//  Created by Gordan Glavaš on 14.06.2021..
//

import SwiftUI
import SwiftUIInfiniteList
import SwiftUIPullToRefresh

struct ContentView: View {
  @ObservedObject var viewModel: ContentViewModel

  var body: some View {
    InfiniteList(data: $viewModel.repos,
                 isLoading: $viewModel.isAppending,
                  loadingView: ProgressView(),
                  loadMore: viewModel.loadMore,
                  onRefresh: viewModel.refresh(refreshComplete:)) { repo in
        VStack(alignment: .leading) {
          Text("\(repo.name ?? "") \(repo.stars) \(repo.forks)")
            .font(.system(size: 14))
            .frame(minWidth: 0, maxWidth: .infinity, alignment: .leading)
          Text(repo.url ?? "")
            .frame(minWidth: 0, maxWidth: .infinity, alignment: .leading)
        }.padding()
    }
  }
}
