//
//  Models.swift
//  SwiftPagingTest
//
//  Created by Gordan Glavaš on 14.06.2021..
//

import Foundation
import CoreData

@objc(Repo)
public class Repo: NSManagedObject {
  public func fromWrapper(_ wrapper: RepoWrapper) {
    id = wrapper.id
    name = wrapper.name
    fullName = wrapper.fullName
    desc = wrapper.description
    url = wrapper.url
    stars = Int32(wrapper.stars)
    forks = Int32(wrapper.forks)
    language = wrapper.language
  }
}

public extension Repo {
  static let entityName = "Repo"
    
  @nonobjc class func fetchRequest() -> NSFetchRequest<Repo> {
    return NSFetchRequest<Repo>(entityName: entityName)
  }

  @NSManaged var id: Int64
  @NSManaged var name: String?
  @NSManaged var fullName: String?
  @NSManaged var desc: String?
  @NSManaged var url: String?
  @NSManaged var stars: Int32
  @NSManaged var forks: Int32
  @NSManaged var language: String?
}

extension Repo : Identifiable {
}

public struct RepoWrapper: Codable, Hashable {
  public let id: Int64
  public let name: String
  public let fullName: String
  public let description: String?
  public let url: String
  public let stars: Int
  public let forks: Int
  public let language: String?
    
  public enum CodingKeys: String, CodingKey {
    case id = "id",
         name = "name",
         fullName = "full_name",
         description = "description",
         url = "html_url",
         stars = "stargazers_count",
         forks = "forks_count",
         language = "language"
  }
}

public struct RepoSearchResponse: Codable {
  public let total: Int?
  public let items: [RepoWrapper]
  public let nextPage: Int?
    
  public enum CodingKeys: String, CodingKey {
    case total = "total_count",
         items = "items",
         nextPage = "nextPage"
  }
}
